package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 发票拖拉机联合收割机对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceTractorsAndCombines;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceTractorsAndCombinesFeignApi {

  /**
   * 通过id查询发票拖拉机联合收割机对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceTractorsAndCombines/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票拖拉机联合收割机对象
   * @param invoiceTractorsAndCombines 发票拖拉机联合收割机对象
   * @return R
   */
  @PostMapping("/invoiceTractorsAndCombines/add")
  public R save(@RequestBody InvoiceTractorsAndCombines invoiceTractorsAndCombines);

  /**
   * 修改发票拖拉机联合收割机对象
   * @param invoiceTractorsAndCombines 发票拖拉机联合收割机对象
   * @return R
   */
  @PostMapping("/invoiceTractorsAndCombines/update")
  public R updateById(@RequestBody InvoiceTractorsAndCombines invoiceTractorsAndCombines);

  /**
   * 通过id删除发票拖拉机联合收割机对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceTractorsAndCombines/del/{id}" )
  public R removeById(@PathVariable Long id);

}