package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 发票建筑服务对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceBuildingService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceBuildingServiceFeignApi {

  /**
   * 通过id查询发票建筑服务对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceBuildingService/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票建筑服务对象
   * @param invoiceBuildingService 发票建筑服务对象
   * @return R
   */
  @PostMapping("/invoiceBuildingService/add")
  public R save(@RequestBody InvoiceBuildingService invoiceBuildingService);

  /**
   * 修改发票建筑服务对象
   * @param invoiceBuildingService 发票建筑服务对象
   * @return R
   */
  @PostMapping("/invoiceBuildingService/update")
  public R updateById(@RequestBody InvoiceBuildingService invoiceBuildingService);

  /**
   * 通过id删除发票建筑服务对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceBuildingService/del/{id}" )
  public R removeById(@PathVariable Long id);

}