package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 前端视图专用feign客户端
 *
 * @author ultraman
 * @date 2025-10-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceMainDto;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceMainDtoFeignApi {

  /**
   * 通过id查询前端视图专用
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceMainDto/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增前端视图专用
   * @param invoiceMainDto 前端视图专用
   * @return R
   */
  @PostMapping("/invoiceMainDto/add")
  public R save(@RequestBody InvoiceMainDto invoiceMainDto);

  /**
   * 修改前端视图专用
   * @param invoiceMainDto 前端视图专用
   * @return R
   */
  @PostMapping("/invoiceMainDto/update")
  public R updateById(@RequestBody InvoiceMainDto invoiceMainDto);

  /**
   * 通过id删除前端视图专用
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceMainDto/del/{id}" )
  public R removeById(@PathVariable Long id);

}