package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 发票医疗服务对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceMedicalService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceMedicalServiceFeignApi {

  /**
   * 通过id查询发票医疗服务对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceMedicalService/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票医疗服务对象
   * @param invoiceMedicalService 发票医疗服务对象
   * @return R
   */
  @PostMapping("/invoiceMedicalService/add")
  public R save(@RequestBody InvoiceMedicalService invoiceMedicalService);

  /**
   * 修改发票医疗服务对象
   * @param invoiceMedicalService 发票医疗服务对象
   * @return R
   */
  @PostMapping("/invoiceMedicalService/update")
  public R updateById(@RequestBody InvoiceMedicalService invoiceMedicalService);

  /**
   * 通过id删除发票医疗服务对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceMedicalService/del/{id}" )
  public R removeById(@PathVariable Long id);

}