package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 代扣代缴凭证勾选任务feign客户端
 *
 * @author ultraman
 * @date 2025-10-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.WithholdingVoucherCheckTask;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface WithholdingVoucherCheckTaskFeignApi {

  /**
   * 通过id查询代扣代缴凭证勾选任务
   * @param  id
   * @return R
   */
  @GetMapping("/withholdingVoucherCheckTask/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增代扣代缴凭证勾选任务
   * @param withholdingVoucherCheckTask 代扣代缴凭证勾选任务
   * @return R
   */
  @PostMapping("/withholdingVoucherCheckTask/add")
  public R save(@RequestBody WithholdingVoucherCheckTask withholdingVoucherCheckTask);

  /**
   * 修改代扣代缴凭证勾选任务
   * @param withholdingVoucherCheckTask 代扣代缴凭证勾选任务
   * @return R
   */
  @PostMapping("/withholdingVoucherCheckTask/update")
  public R updateById(@RequestBody WithholdingVoucherCheckTask withholdingVoucherCheckTask);

  /**
   * 通过id删除代扣代缴凭证勾选任务
   * @param  id
   * @return R
   */
  @DeleteMapping("/withholdingVoucherCheckTask/del/{id}" )
  public R removeById(@PathVariable Long id);

}