package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 记录被删除的发票feign客户端
 *
 * @author ultraman
 * @date 2025-11-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceRecogDelete;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceRecogDeleteFeignApi {

  /**
   * 通过id查询记录被删除的发票
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceRecogDelete/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增记录被删除的发票
   * @param invoiceRecogDelete 记录被删除的发票
   * @return R
   */
  @PostMapping("/invoiceRecogDelete/add")
  public R save(@RequestBody InvoiceRecogDelete invoiceRecogDelete);

  /**
   * 修改记录被删除的发票
   * @param invoiceRecogDelete 记录被删除的发票
   * @return R
   */
  @PostMapping("/invoiceRecogDelete/update")
  public R updateById(@RequestBody InvoiceRecogDelete invoiceRecogDelete);

  /**
   * 通过id删除记录被删除的发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceRecogDelete/del/{id}" )
  public R removeById(@PathVariable Long id);

}