package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 发票池展示对象feign客户端
 *
 * @author ultraman
 * @date 2025-11-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceView;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceViewFeignApi {

  /**
   * 通过id查询发票池展示对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceView/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票池展示对象
   * @param invoiceView 发票池展示对象
   * @return R
   */
  @PostMapping("/invoiceView/add")
  public R save(@RequestBody InvoiceView invoiceView);

  /**
   * 修改发票池展示对象
   * @param invoiceView 发票池展示对象
   * @return R
   */
  @PostMapping("/invoiceView/update")
  public R updateById(@RequestBody InvoiceView invoiceView);

  /**
   * 通过id删除发票池展示对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceView/del/{id}" )
  public R removeById(@PathVariable Long id);

}