package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 销方公司信息feign客户端
 *
 * @author ultraman
 * @date 2025-11-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.SellerCompanyInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface SellerCompanyInfoFeignApi {

  /**
   * 通过id查询销方公司信息
   * @param  id
   * @return R
   */
  @GetMapping("/sellerCompanyInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增销方公司信息
   * @param sellerCompanyInfo 销方公司信息
   * @return R
   */
  @PostMapping("/sellerCompanyInfo/add")
  public R save(@RequestBody SellerCompanyInfo sellerCompanyInfo);

  /**
   * 修改销方公司信息
   * @param sellerCompanyInfo 销方公司信息
   * @return R
   */
  @PostMapping("/sellerCompanyInfo/update")
  public R updateById(@RequestBody SellerCompanyInfo sellerCompanyInfo);

  /**
   * 通过id删除销方公司信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/sellerCompanyInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}