package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * el_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-08-30
 */
public enum ElFlag {

    _0("0", "未勾选"),
    _1("1", "已勾选"),
    _4("4", "已认证"),
    _5("5", "不可勾选");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ElFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ElFlag fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
