package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_category
 * </p>
 *
 * @author ultraman
 * @since 2024-08-30
 */
public enum InvoiceCategory {

    A("A", "扫描发票"),
    B("B", "扫描无订单发票"),
    C("C", "发票扫描导入"),
    D("D", "非增值税发票"),
    EXPENSES_BILL("expensesBill", "费报发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceCategory fromCode(String code){
        switch(code) {
            case "A":
                return A;
            case "B":
                return B;
            case "C":
                return C;
            case "D":
                return D;
            case "expensesBill":
                return EXPENSES_BILL;
            default:
                return null;
        }
    }
}
