package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * special_invoice_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-08-30
 */
public enum SpecialInvoiceFlag {

    _0("0", "无"),
    _1("1", "通行费"),
    _2("2", "成品油"),
    _3("3", "区块链"),
    _5("5", "建筑服务"),
    _6("6", "货物运输服务"),
    _7("7", "不动产销售"),
    _8("8", "不动产经营租赁服务"),
    _9("9", "农产品销售"),
    _10("10", "农产品收购"),
    _11("11", "稀土"),
    _12("12", "通行费可抵扣"),
    _13("13", "通行费不可抵扣"),
    _14("14", "旅客运输服务"),
    _15("15", "机动车"),
    _16("16", "代征车船税"),
    _17("17", "医疗服务（住院）"),
    _18("18", "医疗服务（门诊）"),
    _19("19", "拖拉机和联合收割机"),
    _20("20", "二手车"),
    _21("21", "光伏收购"),
    _22("22", "卷烟"),
    _23("23", "出口"),
    _24("24", "农产品"),
    _25("25", "二手车*"),
    _26("26", "航空运输电子客票行程单"),
    _27("27", "自产农产品销售"),
    _28("28", "差额征税-差额开票"),
    _29("29", "差额征税-全额开票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SpecialInvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialInvoiceFlag fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            case "22":
                return _22;
            case "23":
                return _23;
            case "24":
                return _24;
            case "25":
                return _25;
            case "26":
                return _26;
            case "27":
                return _27;
            case "28":
                return _28;
            case "29":
                return _29;
            default:
                return null;
        }
    }
}
