package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 海关缴款书主信息
 * </p>
 *
 * @author ultraman
 * @since 2024-08-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CustomsPayment implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 海关缴款书编号
   */
  private String customsPaymentNo;

  /**
   * 收入系统
   */
  private String incomeSystem;

  /**
   * 填发日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime issuingDate;

  /**
   * 收入机关
   */
  private String receiptOffice;

  /**
   * 科目
   */
  private String receiptSubject;

  /**
   * 收款国库
   */
  private String receiptTreasury;

  /**
   * 预算级次
   */
  private String receiptBudgetLevel;

  /**
   * 缴款名称
   */
  private String payName;

  /**
   * 缴款帐号
   */
  private String payAccount;

  /**
   * 缴款开户行
   */
  private String payBank;

  /**
   * 金额人民币大写
   */
  private String amountCapital;

  /**
   * 金额总计
   */
  private BigDecimal totalAmount;

  /**
   * 申报单位编号
   */
  private String declareUnitNo;

  /**
   * 报关单编号
   */
  private String declarationFormNo;

  /**
   * 合同(批文)号
   */
  private String contractNo;

  /**
   * 运输工具号
   */
  private String transportNo;

  /**
   * 缴款期限
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payDeadline;

  /**
   * 提/装货单号
   */
  private String pickLoadNo;

  /**
   * 备注
   */
  private String remark;

  /**
   * 制单人
   */
  private String documenter;

  /**
   * 复核人
   */
  private String checkerName;

  /**
   * 口岸名称
   */
  private String portName;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 可抵扣税额
   */
  private BigDecimal effectiveTaxAmount;

  /**
   * 勾选时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;

  /**
   * 抵扣用途
   */
  private String authUse;

  /**
   * 认证状态
   */
  private String authStatus;

  /**
   * 税款所属期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTaxPeriod;

  /**
   * 签名确认日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authBussiDate;

  /**
   * 管理状态
   */
  private String manageStatus;

  /**
   * 客户端账号
   */
  private String clientNo;

  /**
   * 勾选人id
   */
  private Long checkUserId;

  /**
   * 勾选人姓名
   */
  private String checkUserName;

  /**
   * 认证备注
   */
  private String authRemark;

  /**
   * 组织id
   */
  private Long orgId;

  /**
   * 公司税号
   */
  private String companyTaxNo;

  /**
   * 组织code
   */
  private String orgCode;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 稽核状态
   */
  private String inspectStatus;

  /**
   * 稽核备注
   */
  private String inspectRemark;

  /**
   * 记账状态
   */
  private String chargeUpStatus;

  /**
   * 记账单号
   */
  private String chargeUpNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 底账是否已到
   */
  private String elSyncFlag;

  /**
   * 识别状态
   */
  private String recogStatus;

  /**
   * 识别时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recogTime;

  /**
   * 扫描人姓名
   */
  private String recogUserName;

  /**
   * 记账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeUpPeriod;

  /**
   * 公司id
   */
  private Long companyId;

  /**
   * 认证方式
   */
  private String authStyle;

  /**
   * 勾选任务id
   */
  private String authTaskId;

  /**
   * 功能组别
   */
  private String functionGroup;

  /**
   * 勾选请求时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authRequestTime;

  /**
   * JV/CODE
   */
  private String jvCode;

  /**
   * 门店编码
   */
  private String storeCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("customs_payment_no", customsPaymentNo);
      map.put("income_system", incomeSystem);
      map.put("issuing_date", BocpGenUtils.toTimestamp(issuingDate));
      map.put("receipt_office", receiptOffice);
      map.put("receipt_subject", receiptSubject);
      map.put("receipt_treasury", receiptTreasury);
      map.put("receipt_budget_level", receiptBudgetLevel);
      map.put("pay_name", payName);
      map.put("pay_account", payAccount);
      map.put("pay_bank", payBank);
      map.put("amount_capital", amountCapital);
      map.put("total_amount", totalAmount);
      map.put("declare_unit_no", declareUnitNo);
      map.put("declaration_form_no", declarationFormNo);
      map.put("contract_no", contractNo);
      map.put("transport_no", transportNo);
      map.put("pay_deadline", BocpGenUtils.toTimestamp(payDeadline));
      map.put("pick_load_no", pickLoadNo);
      map.put("remark", remark);
      map.put("documenter", documenter);
      map.put("checker_name", checkerName);
      map.put("port_name", portName);
      map.put("tax_amount", taxAmount);
      map.put("effective_tax_amount", effectiveTaxAmount);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("auth_use", authUse);
      map.put("auth_status", authStatus);
      map.put("auth_tax_period", BocpGenUtils.toTimestamp(authTaxPeriod));
      map.put("auth_bussi_date", BocpGenUtils.toTimestamp(authBussiDate));
      map.put("manage_status", manageStatus);
      map.put("client_no", clientNo);
      map.put("check_user_id", checkUserId);
      map.put("check_user_name", checkUserName);
      map.put("auth_remark", authRemark);
      map.put("org_id", orgId);
      map.put("company_tax_no", companyTaxNo);
      map.put("org_code", orgCode);
      map.put("company_name", companyName);
      map.put("inspect_status", inspectStatus);
      map.put("inspect_remark", inspectRemark);
      map.put("charge_up_status", chargeUpStatus);
      map.put("charge_up_no", chargeUpNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("el_sync_flag", elSyncFlag);
      map.put("recog_status", recogStatus);
      map.put("recog_time", BocpGenUtils.toTimestamp(recogTime));
      map.put("recog_user_name", recogUserName);
      map.put("charge_up_period", BocpGenUtils.toTimestamp(chargeUpPeriod));
      map.put("company_id", companyId);
      map.put("auth_style", authStyle);
      map.put("auth_task_id", authTaskId);
      map.put("function_group", functionGroup);
      map.put("auth_request_time", BocpGenUtils.toTimestamp(authRequestTime));
      map.put("jv_code", jvCode);
      map.put("store_code", storeCode);

      return map;
  }

  public static CustomsPayment fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CustomsPayment entity = new CustomsPayment();
    if(map.containsKey("customs_payment_no")) {
      Object obj = map.get("customs_payment_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomsPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("income_system")) {
      Object obj = map.get("income_system");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIncomeSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuing_date")) {
      Object obj = map.get("issuing_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIssuingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setIssuingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIssuingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setIssuingDate(null);
      }
    }
    if(map.containsKey("receipt_office")) {
      Object obj = map.get("receipt_office");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptOffice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receipt_subject")) {
      Object obj = map.get("receipt_subject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptSubject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receipt_treasury")) {
      Object obj = map.get("receipt_treasury");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptTreasury((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receipt_budget_level")) {
      Object obj = map.get("receipt_budget_level");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptBudgetLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_name")) {
      Object obj = map.get("pay_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_account")) {
      Object obj = map.get("pay_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_bank")) {
      Object obj = map.get("pay_bank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_capital")) {
      Object obj = map.get("amount_capital");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountCapital((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("declare_unit_no")) {
      Object obj = map.get("declare_unit_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeclareUnitNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("declaration_form_no")) {
      Object obj = map.get("declaration_form_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeclarationFormNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_no")) {
      Object obj = map.get("contract_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transport_no")) {
      Object obj = map.get("transport_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransportNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_deadline")) {
      Object obj = map.get("pay_deadline");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayDeadline(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayDeadline((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayDeadline(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayDeadline(null);
      }
    }
    if(map.containsKey("pick_load_no")) {
      Object obj = map.get("pick_load_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPickLoadNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documenter")) {
      Object obj = map.get("documenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("port_name")) {
      Object obj = map.get("port_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPortName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthTaxPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTaxPeriod(null);
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthBussiDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthBussiDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthBussiDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthBussiDate(null);
      }
    }
    if(map.containsKey("manage_status")) {
      Object obj = map.get("manage_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManageStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("client_no")) {
      Object obj = map.get("client_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClientNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inspect_status")) {
      Object obj = map.get("inspect_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInspectStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inspect_remark")) {
      Object obj = map.get("inspect_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInspectRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("el_sync_flag")) {
      Object obj = map.get("el_sync_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElSyncFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecogTime(null);
      }
    }
    if(map.containsKey("recog_user_name")) {
      Object obj = map.get("recog_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setChargeUpPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeUpPeriod(null);
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_task_id")) {
      Object obj = map.get("auth_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("function_group")) {
      Object obj = map.get("function_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFunctionGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_request_time")) {
      Object obj = map.get("auth_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuthRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthRequestTime(null);
      }
    }
    if(map.containsKey("jv_code")) {
      Object obj = map.get("jv_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJvCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("customs_payment_no")) {
      Object obj = map.get("customs_payment_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomsPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("income_system")) {
      Object obj = map.get("income_system");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIncomeSystem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issuing_date")) {
      Object obj = map.get("issuing_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIssuingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setIssuingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIssuingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setIssuingDate(null);
      }
    }
    if(map.containsKey("receipt_office")) {
      Object obj = map.get("receipt_office");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptOffice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receipt_subject")) {
      Object obj = map.get("receipt_subject");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptSubject((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receipt_treasury")) {
      Object obj = map.get("receipt_treasury");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptTreasury((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receipt_budget_level")) {
      Object obj = map.get("receipt_budget_level");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptBudgetLevel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_name")) {
      Object obj = map.get("pay_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_account")) {
      Object obj = map.get("pay_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_bank")) {
      Object obj = map.get("pay_bank");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_capital")) {
      Object obj = map.get("amount_capital");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountCapital((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("declare_unit_no")) {
      Object obj = map.get("declare_unit_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeclareUnitNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("declaration_form_no")) {
      Object obj = map.get("declaration_form_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeclarationFormNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contract_no")) {
      Object obj = map.get("contract_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transport_no")) {
      Object obj = map.get("transport_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransportNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_deadline")) {
      Object obj = map.get("pay_deadline");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayDeadline(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayDeadline((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayDeadline(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayDeadline(null);
      }
    }
    if(map.containsKey("pick_load_no")) {
      Object obj = map.get("pick_load_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPickLoadNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documenter")) {
      Object obj = map.get("documenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("port_name")) {
      Object obj = map.get("port_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPortName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthUse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthTaxPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthTaxPeriod(null);
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthBussiDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthBussiDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuthBussiDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthBussiDate(null);
      }
    }
    if(map.containsKey("manage_status")) {
      Object obj = map.get("manage_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManageStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("client_no")) {
      Object obj = map.get("client_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClientNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCheckUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inspect_status")) {
      Object obj = map.get("inspect_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInspectStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inspect_remark")) {
      Object obj = map.get("inspect_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInspectRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUpNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("el_sync_flag")) {
      Object obj = map.get("el_sync_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElSyncFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recog_time")) {
      Object obj = map.get("recog_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRecogTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRecogTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRecogTime(null);
      }
    }
    if(map.containsKey("recog_user_name")) {
      Object obj = map.get("recog_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecogUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChargeUpPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setChargeUpPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeUpPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setChargeUpPeriod(null);
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStyle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_task_id")) {
      Object obj = map.get("auth_task_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("function_group")) {
      Object obj = map.get("function_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFunctionGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auth_request_time")) {
      Object obj = map.get("auth_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuthRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuthRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuthRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuthRequestTime(null);
      }
    }
    if(map.containsKey("jv_code")) {
      Object obj = map.get("jv_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_code")) {
      Object obj = map.get("store_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreCode((String)obj);
        }
      } else {
      }
    }
  }
}
