package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_drawback_check_tab_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum InvoiceDrawbackCheckTabFlag {

    可勾选("可勾选", "可勾选"),
    配置拦截("配置拦截", "配置拦截"),
    不可勾选("不可勾选", "不可勾选"),
    已勾选("已勾选", "已勾选"),
    已认证("已认证", "已认证"),
    已转出("已转出", "已转出");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceDrawbackCheckTabFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceDrawbackCheckTabFlag fromCode(String code){
        switch(code) {
            case "可勾选":
                return 可勾选;
            case "配置拦截":
                return 配置拦截;
            case "不可勾选":
                return 不可勾选;
            case "已勾选":
                return 已勾选;
            case "已认证":
                return 已认证;
            case "已转出":
                return 已转出;
            default:
                return null;
        }
    }
}
