package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * match_send_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum MatchSendStatus {

    _0("0", "待下发"),
    _1("1", "下发中"),
    _2("2", "下发成功"),
    _3("3", "下发等待"),
    _9("9", "下发失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MatchSendStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchSendStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
