package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * type_of_vehicle
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum TypeOfVehicle {

    _1("1", "飞机"),
    _2("2", "火车"),
    _3("3", "长途汽车"),
    _4("4", "公共交通"),
    _5("5", "出租车"),
    _6("6", "汽车"),
    _7("7", "船舶"),
    _9("9", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TypeOfVehicle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TypeOfVehicle fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
