package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_pool_system_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-01
 */
public enum InvoicePoolSystemType {

    SAP0("SAP0", "SAP 非协同"),
    SAP1("SAP1", "SAP 协同"),
    EAS0("EAS0", "EAS 非协同");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoicePoolSystemType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoicePoolSystemType fromCode(String code){
        switch(code) {
            case "SAP0":
                return SAP0;
            case "SAP1":
                return SAP1;
            case "EAS0":
                return EAS0;
            default:
                return null;
        }
    }
}
