package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ncp_manage_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-01
 */
public enum NcpManageStatus {

    _0("0", "无"),
    _01("01", "正常"),
    _03("03", "疑点发票"),
    _02("02", "异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NcpManageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpManageStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "01":
                return _01;
            case "03":
                return _03;
            case "02":
                return _02;
            default:
                return null;
        }
    }
}
