package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * transport_tool_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-01
 */
public enum TransportToolType {

    _01("01", "铁路运输"),
    _02("02", "公路运输"),
    _03("03", "水路运输"),
    _04("04", "航空运输"),
    _05("05", "管道运输"),
    _06("06", "其他运输工具"),
    _07("07", "汽运");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TransportToolType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TransportToolType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            default:
                return null;
        }
    }
}
