package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext_gmry
 * </p>
 *
 * @author ultraman
 * @since 2025-03-12
 */
public enum ExtGMRY {

    _584("584", "股份公司总部"),
    _622("622", "上海社区部"),
    _599("599", "学生奶事业部"),
    _255("255", "奶粉事业部"),
    _254("254", "UHT事业部"),
    _6382("6382", "中央工厂"),
    _7944("7944", "华东中心工厂"),
    _2502("2502", "华东生产总部"),
    _11765("11765", "电商营销中心"),
    _8745("8745", "研究院"),
    _631("631", "乳品二厂"),
    _641("641", "上海商超部"),
    _646("646", "酸奶事业部八厂");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExtGMRY(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExtGMRY fromCode(String code){
        switch(code) {
            case "584":
                return _584;
            case "622":
                return _622;
            case "599":
                return _599;
            case "255":
                return _255;
            case "254":
                return _254;
            case "6382":
                return _6382;
            case "7944":
                return _7944;
            case "2502":
                return _2502;
            case "11765":
                return _11765;
            case "8745":
                return _8745;
            case "631":
                return _631;
            case "641":
                return _641;
            case "646":
                return _646;
            default:
                return null;
        }
    }
}
