package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * un_certified_reason
 * </p>
 *
 * @author ultraman
 * @since 2025-03-12
 */
public enum UnCertifiedReason {

    _1("1", "发票信息/内容有误，无法抵扣"),
    _2("2", "已收到发票原件，待抵扣"),
    _3("3", "发票丢失"),
    _4("4", "未结算，已收到发票原件，待结算后抵扣"),
    _5("5", "未结算，未收到发票原件"),
    _6("6", "已结算，未收到发票原件"),
    _7("7", "其他"),
    _0("0", "无");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    UnCertifiedReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UnCertifiedReason fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
