package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 发票医疗服务对象
 * </p>
 *
 * @author ultraman
 * @since 2025-03-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMedicalService implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 医保范围内费用
   */
  private String ybfwnfy;

  /**
   * 个人自付金额
   */
  private String grzfje;

  /**
   * 公务员补助基金支出
   */
  private String gwybzjjzc;

  /**
   * 企业补充医疗基金支出
   */
  private String qybcyljjzc;

  /**
   * 基本医疗统筹支付金额
   */
  private String jbyltczfje;

  /**
   * 现金支付
   */
  private String xjzfje;

  /**
   * 医疗人员补助基金支出
   */
  private String ylrybzjjzc;

  /**
   * 其他补助基金支出
   */
  private String qtbzjjzc;

  /**
   * 大病医疗统筹支付金额
   */
  private String dbyltczfje;

  /**
   * 医保个人账户支付
   */
  private String ybgrzhzf;

  /**
   * 退干补助基金支出
   */
  private String tgbzjjzc;

  /**
   * 民政救助金额
   */
  private String mzjzje;

  /**
   * 医保卡号
   */
  private String ybkh;

  /**
   * 医保账户余额
   */
  private String ybzhye;

  /**
   * 退休补助基金支出
   */
  private String txbzjjzc;

  /**
   * 民政救济金额
   */
  private String mzjjje;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 全电发票号码
   */
  private String allElectricInvoiceNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 费用名称
   */
  private String expenseName;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 invoiceMain
   */
    private Long invoiceMedicalServiceAndInvoiceMainRelationId;
  /**
   * 对一关联关系 关联对象 invoiceView
   */
    private Long invoiceMedicalServiceAndInvoiceViewRelationId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ybfwnfy", ybfwnfy);
      map.put("grzfje", grzfje);
      map.put("gwybzjjzc", gwybzjjzc);
      map.put("qybcyljjzc", qybcyljjzc);
      map.put("jbyltczfje", jbyltczfje);
      map.put("xjzfje", xjzfje);
      map.put("ylrybzjjzc", ylrybzjjzc);
      map.put("qtbzjjzc", qtbzjjzc);
      map.put("dbyltczfje", dbyltczfje);
      map.put("ybgrzhzf", ybgrzhzf);
      map.put("tgbzjjzc", tgbzjjzc);
      map.put("mzjzje", mzjzje);
      map.put("ybkh", ybkh);
      map.put("ybzhye", ybzhye);
      map.put("txbzjjzc", txbzjjzc);
      map.put("mzjjje", mzjjje);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("all_electric_invoice_no", allElectricInvoiceNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("expense_name", expenseName);
      map.put("org_tree", orgTree);

       map.put("invoiceMedicalServiceAndInvoiceMainRelation.id", invoiceMedicalServiceAndInvoiceMainRelationId);
       map.put("invoiceMedicalServiceAndInvoiceViewRelation.id", invoiceMedicalServiceAndInvoiceViewRelationId);
      return map;
  }

  public static InvoiceMedicalService fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceMedicalService entity = new InvoiceMedicalService();
    if(map.containsKey("ybfwnfy")) {
      Object obj = map.get("ybfwnfy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYbfwnfy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grzfje")) {
      Object obj = map.get("grzfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGrzfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gwybzjjzc")) {
      Object obj = map.get("gwybzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGwybzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qybcyljjzc")) {
      Object obj = map.get("qybcyljjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQybcyljjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jbyltczfje")) {
      Object obj = map.get("jbyltczfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJbyltczfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xjzfje")) {
      Object obj = map.get("xjzfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXjzfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ylrybzjjzc")) {
      Object obj = map.get("ylrybzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYlrybzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qtbzjjzc")) {
      Object obj = map.get("qtbzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQtbzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dbyltczfje")) {
      Object obj = map.get("dbyltczfje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDbyltczfje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ybgrzhzf")) {
      Object obj = map.get("ybgrzhzf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYbgrzhzf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tgbzjjzc")) {
      Object obj = map.get("tgbzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTgbzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mzjzje")) {
      Object obj = map.get("mzjzje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMzjzje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ybkh")) {
      Object obj = map.get("ybkh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYbkh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ybzhye")) {
      Object obj = map.get("ybzhye");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYbzhye((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("txbzjjzc")) {
      Object obj = map.get("txbzjjzc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTxbzjjzc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mzjjje")) {
      Object obj = map.get("mzjjje");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMzjjje((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expense_name")) {
      Object obj = map.get("expense_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("invoiceMedicalServiceAndInvoiceMainRelation.id")) {
        Object obj = map.get("invoiceMedicalServiceAndInvoiceMainRelation.id");
      if(obj instanceof Long) {
        entity.setInvoiceMedicalServiceAndInvoiceMainRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceMedicalServiceAndInvoiceMainRelationId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("invoiceMedicalServiceAndInvoiceViewRelation.id")) {
        Object obj = map.get("invoiceMedicalServiceAndInvoiceViewRelation.id");
      if(obj instanceof Long) {
        entity.setInvoiceMedicalServiceAndInvoiceViewRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceMedicalServiceAndInvoiceViewRelationId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ybfwnfy")) {
      Object obj = map.get("ybfwnfy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYbfwnfy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("grzfje")) {
      Object obj = map.get("grzfje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGrzfje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gwybzjjzc")) {
      Object obj = map.get("gwybzjjzc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGwybzjjzc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("qybcyljjzc")) {
      Object obj = map.get("qybcyljjzc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQybcyljjzc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jbyltczfje")) {
      Object obj = map.get("jbyltczfje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJbyltczfje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xjzfje")) {
      Object obj = map.get("xjzfje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXjzfje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ylrybzjjzc")) {
      Object obj = map.get("ylrybzjjzc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYlrybzjjzc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("qtbzjjzc")) {
      Object obj = map.get("qtbzjjzc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQtbzjjzc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dbyltczfje")) {
      Object obj = map.get("dbyltczfje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDbyltczfje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ybgrzhzf")) {
      Object obj = map.get("ybgrzhzf");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYbgrzhzf((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tgbzjjzc")) {
      Object obj = map.get("tgbzjjzc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTgbzjjzc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mzjzje")) {
      Object obj = map.get("mzjzje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMzjzje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ybkh")) {
      Object obj = map.get("ybkh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYbkh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ybzhye")) {
      Object obj = map.get("ybzhye");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYbzhye((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("txbzjjzc")) {
      Object obj = map.get("txbzjjzc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTxbzjjzc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mzjjje")) {
      Object obj = map.get("mzjjje");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMzjjje((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("all_electric_invoice_no")) {
      Object obj = map.get("all_electric_invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllElectricInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expense_name")) {
      Object obj = map.get("expense_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("invoiceMedicalServiceAndInvoiceMainRelation.id")) {
        Object obj = map.get("invoiceMedicalServiceAndInvoiceMainRelation.id");
        if(obj instanceof Long) {
          this.setInvoiceMedicalServiceAndInvoiceMainRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceMedicalServiceAndInvoiceMainRelationId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("invoiceMedicalServiceAndInvoiceViewRelation.id")) {
        Object obj = map.get("invoiceMedicalServiceAndInvoiceViewRelation.id");
        if(obj instanceof Long) {
          this.setInvoiceMedicalServiceAndInvoiceViewRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceMedicalServiceAndInvoiceViewRelationId(Long.parseLong((String)obj));
        }
      }
  }
}
