package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 火车票对象
 * </p>
 *
 * @author ultraman
 * @since 2025-03-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TrainTicket implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 业务类型
   */
  private String businessType;

  /**
   * 电子客票号
   */
  private String eticketNo;

  /**
   * 旅客姓名
   */
  private String nameOfPassenger;

  /**
   * 证件号码
   */
  private String idNumber;

  /**
   * 出发站
   */
  private String from;

  /**
   * 到达站
   */
  private String to;

  /**
   * 车次
   */
  private String trainNumber;

  /**
   * 乘车日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime date;

  /**
   * 席别
   */
  private String railwaySeats;

  /**
   * 车厢
   */
  private String railwayCarriage;

  /**
   * 席位
   */
  private String seat;

  /**
   * 票种
   */
  private String ticketType;

  /**
   * 空调特征
   */
  private String airConditioning;

  /**
   * 特殊备注
   */
  private String specialNotes;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 出发时间
   */
  private String departureTime;

  /**
   * 原票票价
   */
  private String originalPrice;

  /**
   * 已退金额
   */
  private String refundedAmount;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoice_no", invoiceNo);
      map.put("business_type", businessType);
      map.put("eticket_no", eticketNo);
      map.put("name_of_passenger", nameOfPassenger);
      map.put("id_number", idNumber);
      map.put("from", from);
      map.put("to", to);
      map.put("train_number", trainNumber);
      map.put("date", BocpGenUtils.toTimestamp(date));
      map.put("railway_seats", railwaySeats);
      map.put("railway_carriage", railwayCarriage);
      map.put("seat", seat);
      map.put("ticket_type", ticketType);
      map.put("air_conditioning", airConditioning);
      map.put("special_notes", specialNotes);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("departure_time", departureTime);
      map.put("original_price", originalPrice);
      map.put("refunded_amount", refundedAmount);
      map.put("org_tree", orgTree);

      return map;
  }

  public static TrainTicket fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TrainTicket entity = new TrainTicket();
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("eticket_no")) {
      Object obj = map.get("eticket_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEticketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name_of_passenger")) {
      Object obj = map.get("name_of_passenger");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNameOfPassenger((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id_number")) {
      Object obj = map.get("id_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIdNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("from")) {
      Object obj = map.get("from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("to")) {
      Object obj = map.get("to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("train_number")) {
      Object obj = map.get("train_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTrainNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("date")) {
      Object obj = map.get("date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDate(null);
      }
    }
    if(map.containsKey("railway_seats")) {
      Object obj = map.get("railway_seats");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRailwaySeats((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("railway_carriage")) {
      Object obj = map.get("railway_carriage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRailwayCarriage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seat")) {
      Object obj = map.get("seat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_type")) {
      Object obj = map.get("ticket_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("air_conditioning")) {
      Object obj = map.get("air_conditioning");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAirConditioning((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("special_notes")) {
      Object obj = map.get("special_notes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialNotes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departure_time")) {
      Object obj = map.get("departure_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDepartureTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("original_price")) {
      Object obj = map.get("original_price");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refunded_amount")) {
      Object obj = map.get("refunded_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("eticket_no")) {
      Object obj = map.get("eticket_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEticketNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("name_of_passenger")) {
      Object obj = map.get("name_of_passenger");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNameOfPassenger((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id_number")) {
      Object obj = map.get("id_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIdNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("from")) {
      Object obj = map.get("from");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("to")) {
      Object obj = map.get("to");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("train_number")) {
      Object obj = map.get("train_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTrainNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("date")) {
      Object obj = map.get("date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDate(null);
      }
    }
    if(map.containsKey("railway_seats")) {
      Object obj = map.get("railway_seats");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRailwaySeats((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("railway_carriage")) {
      Object obj = map.get("railway_carriage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRailwayCarriage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seat")) {
      Object obj = map.get("seat");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSeat((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_type")) {
      Object obj = map.get("ticket_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("air_conditioning")) {
      Object obj = map.get("air_conditioning");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAirConditioning((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("special_notes")) {
      Object obj = map.get("special_notes");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialNotes((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("departure_time")) {
      Object obj = map.get("departure_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartureTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("original_price")) {
      Object obj = map.get("original_price");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalPrice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refunded_amount")) {
      Object obj = map.get("refunded_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundedAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
