package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_tag1_jkl
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum BizTag1JKL {

    _1("1", "结算中心"),
    _2("2", "费用"),
    结算中心("结算中心", "结算中心"),
    集团总部("集团总部", "集团总部"),
    生鲜配送("生鲜配送", "生鲜配送"),
    便利店("便利店", "便利店"),
    首超("首超", "首超"),
    通州("通州", "通州");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizTag1JKL(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizTag1JKL fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "结算中心":
                return 结算中心;
            case "集团总部":
                return 集团总部;
            case "生鲜配送":
                return 生鲜配送;
            case "便利店":
                return 便利店;
            case "首超":
                return 首超;
            case "通州":
                return 通州;
            default:
                return null;
        }
    }
}
