package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * entry_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum EntryStatus {

    _02("02", "已入账（企业所得税税前扣除）"),
    _03("03", "已入账（企业所得税不扣除）"),
    _06("06", "入账撤销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EntryStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EntryStatus fromCode(String code){
        switch(code) {
            case "02":
                return _02;
            case "03":
                return _03;
            case "06":
                return _06;
            default:
                return null;
        }
    }
}
