package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * file_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum FileType {

    _0("0", "无"),
    JPG("jpg", "jpg"),
    PNG("png", "png"),
    PDF("pdf", "pdf"),
    OFD("ofd", "ofd"),
    JPEG("jpeg", "jpeg"),
    XML("xml", "xml");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "jpg":
                return JPG;
            case "png":
                return PNG;
            case "pdf":
                return PDF;
            case "ofd":
                return OFD;
            case "jpeg":
                return JPEG;
            case "xml":
                return XML;
            default:
                return null;
        }
    }
}
