package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pur_company_exception_content
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum PurCompanyExceptionContent {

    _1("1", "抬头不一致"),
    _2("2", "地址电话不一致"),
    _3("3", "银行信息不一致"),
    _4("4", "公司信息未维护"),
    _5("5", "验真人没有发票权限"),
    _0("0", "未知");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PurCompanyExceptionContent(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurCompanyExceptionContent fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
