package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * seller_issued_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum SellerIssuedStatus {

    _1("1", "销方未开具"),
    _2("2", "销方已开具");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SellerIssuedStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerIssuedStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
