package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_rate_definition
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum TaxRateDefinition {

    _0("0", "0%"),
    _3("3", "3%"),
    _5("5", "5%"),
    _6("6", "6%"),
    _9("9", "9%"),
    _11("11", "11%"),
    _13("13", "13%"),
    _16("16", "16%"),
    _17("17", "17%"),
    _1("1", "1%"),
    _1_5("1.5", "1.5%"),
    _10("10", "10%");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxRateDefinition(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxRateDefinition fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "3":
                return _3;
            case "5":
                return _5;
            case "6":
                return _6;
            case "9":
                return _9;
            case "11":
                return _11;
            case "13":
                return _13;
            case "16":
                return _16;
            case "17":
                return _17;
            case "1":
                return _1;
            case "1.5":
                return _1_5;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
