package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 机动车额外信息
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceVehicle implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 组织机构代码
   */
  private String organizationCode;

  /**
   * 车辆类型
   */
  private String vehicleType;

  /**
   * 厂牌型号
   */
  private String vehicleBrand;

  /**
   * 产地
   */
  private String productionArea;

  /**
   * 合格证号
   */
  private String certNo;

  /**
   * 商检单号
   */
  private String inspectionNo;

  /**
   * 发动机号码
   */
  private String engineNo;

  /**
   * 车架号码
   */
  private String vehicleNo;

  /**
   * 征收税率
   */
  private String taxRate;

  /**
   * 吨位
   */
  private String tonnage;

  /**
   * 限乘人数
   */
  private String maxCapacity;

  /**
   * 进口证明书号
   */
  private String importCertNo;

  /**
   * 税务机关名称
   */
  private String taxAuthName;

  /**
   * 税务机关代码
   */
  private String taxAuthCode;

  /**
   * 完税凭证号码
   */
  private String taxPaidProof;

  /**
   * 组织id
   */
  private Long orgId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 invoiceMain
   */
    private Long invoiceVehicleAndInvoiceMainRelationId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("organization_code", organizationCode);
      map.put("vehicle_type", vehicleType);
      map.put("vehicle_brand", vehicleBrand);
      map.put("production_area", productionArea);
      map.put("cert_no", certNo);
      map.put("inspection_no", inspectionNo);
      map.put("engine_no", engineNo);
      map.put("vehicle_no", vehicleNo);
      map.put("tax_rate", taxRate);
      map.put("tonnage", tonnage);
      map.put("max_capacity", maxCapacity);
      map.put("import_cert_no", importCertNo);
      map.put("tax_auth_name", taxAuthName);
      map.put("tax_auth_code", taxAuthCode);
      map.put("tax_paid_proof", taxPaidProof);
      map.put("org_id", orgId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_tree", orgTree);

       map.put("invoiceVehicleAndInvoiceMainRelation.id", invoiceVehicleAndInvoiceMainRelationId);
      return map;
  }

  public static InvoiceVehicle fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceVehicle entity = new InvoiceVehicle();
    if(map.containsKey("organization_code")) {
      Object obj = map.get("organization_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("production_area")) {
      Object obj = map.get("production_area");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductionArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cert_no")) {
      Object obj = map.get("cert_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCertNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inspection_no")) {
      Object obj = map.get("inspection_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInspectionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("engine_no")) {
      Object obj = map.get("engine_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEngineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_no")) {
      Object obj = map.get("vehicle_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTonnage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("max_capacity")) {
      Object obj = map.get("max_capacity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaxCapacity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_cert_no")) {
      Object obj = map.get("import_cert_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportCertNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_auth_name")) {
      Object obj = map.get("tax_auth_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAuthName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_auth_code")) {
      Object obj = map.get("tax_auth_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAuthCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_paid_proof")) {
      Object obj = map.get("tax_paid_proof");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPaidProof((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("invoiceVehicleAndInvoiceMainRelation.id")) {
        Object obj = map.get("invoiceVehicleAndInvoiceMainRelation.id");
      if(obj instanceof Long) {
        entity.setInvoiceVehicleAndInvoiceMainRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceVehicleAndInvoiceMainRelationId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("organization_code")) {
      Object obj = map.get("organization_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("production_area")) {
      Object obj = map.get("production_area");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductionArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cert_no")) {
      Object obj = map.get("cert_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCertNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inspection_no")) {
      Object obj = map.get("inspection_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInspectionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("engine_no")) {
      Object obj = map.get("engine_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEngineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicle_no")) {
      Object obj = map.get("vehicle_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTonnage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("max_capacity")) {
      Object obj = map.get("max_capacity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaxCapacity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("import_cert_no")) {
      Object obj = map.get("import_cert_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportCertNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_auth_name")) {
      Object obj = map.get("tax_auth_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAuthName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_auth_code")) {
      Object obj = map.get("tax_auth_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAuthCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_paid_proof")) {
      Object obj = map.get("tax_paid_proof");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPaidProof((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("invoiceVehicleAndInvoiceMainRelation.id")) {
        Object obj = map.get("invoiceVehicleAndInvoiceMainRelation.id");
        if(obj instanceof Long) {
          this.setInvoiceVehicleAndInvoiceMainRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceVehicleAndInvoiceMainRelationId(Long.parseLong((String)obj));
        }
      }
  }
}
