package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bookkeeping
 * </p>
 *
 * @author ultraman
 * @since 2024-07-30
 */
public enum Bookkeeping {

    _0("0", "未记账"),
    _1("1", "已记账"),
    _2("2", "记账失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Bookkeeping(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Bookkeeping fromCode(String code) {
        return Stream.of(Bookkeeping.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
