package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_legal_synergetics
 * </p>
 *
 * @author ultraman
 * @since 2024-07-30
 */
public enum IsLegalSynergetics {

    是("是", "是"),
    否("否", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsLegalSynergetics(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsLegalSynergetics fromCode(String code) {
        return Stream.of(IsLegalSynergetics.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
