package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ncp_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-30
 */
public enum NcpType {

    _0("0", "无"),
    _1("1", "自产农产品销售发票"),
    _2("2", "从小规模处购进的3%农产品专票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NcpType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpType fromCode(String code) {
        return Stream.of(NcpType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
