package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recog_delete_remark
 * </p>
 *
 * @author ultraman
 * @since 2024-07-30
 */
public enum RecogDeleteRemark {

    _0("0", "--"),
    _1("1", "发票类型开错"),
    _2("2", "附件里含有敏感信息"),
    _3("3", "实票与预票不一致-品名有误"),
    _4("4", "实票与预票不一致-税收编码有误"),
    _5("5", "实票与预票不一致-备注栏-地址备注有误"),
    _6("6", "实票与预票不一致-备注栏-项目名称有误"),
    _7("7", "实票与预票不一致-金额有误"),
    _8("8", "实票与预票不一致-税率有误"),
    _9("9", "实票与预票不一致-发票抬头开错"),
    _10("10", "实票与预票不一致-购方税号开错"),
    _11("11", "单价、数量未拆分"),
    _12("12", "购方开票信息不全"),
    _13("13", "产值被驳回"),
    _14("14", "产值单缺少附件"),
    _15("15", "产值需走线下"),
    _16("16", "单价小于“1”，不符合实际"),
    _17("17", "发票状态异常"),
    _18("18", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RecogDeleteRemark(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecogDeleteRemark fromCode(String code) {
        return Stream.of(RecogDeleteRemark.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
