package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * send_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-30
 */
public enum SendType {

    _1("1", "下发销项"),
    _2("2", "下发集成"),
    _3("3", "下发协同");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SendType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendType fromCode(String code) {
        return Stream.of(SendType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
