package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * actual_auth_way
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum ActualAuthWay {

    _0("0", "无"),
    _1("1", "手工调整");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ActualAuthWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ActualAuthWay fromCode(String code) {
        return Stream.of(ActualAuthWay.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
