package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_use
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum AuthUse {

    _1("1", "抵扣勾选"),
    _2("2", "不抵扣勾选"),
    _3("3", "退税勾选"),
    _10("10", "撤销抵扣勾选"),
    _20("20", "撤销不抵扣勾选"),
    _30("30", "撤销退税勾选"),
    _0("0", "无");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthUse(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthUse fromCode(String code) {
        return Stream.of(AuthUse.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
