package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cross_city_sign
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum CrossCitySign {

    Y("Y", "是"),
    N("N", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CrossCitySign(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CrossCitySign fromCode(String code) {
        return Stream.of(CrossCitySign.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
