package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dimension
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum Dimension {

    _0("0", "全局"),
    _1("1", "公司"),
    _2("2", "部门"),
    _3("3", "个人");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Dimension(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Dimension fromCode(String code) {
        return Stream.of(Dimension.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
