package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * match_send_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum MatchSendStatus {

    _0("0", "待下发"),
    _1("1", "下发中"),
    _2("2", "下发成功"),
    _3("3", "下发等待"),
    _9("9", "下发失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchSendStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchSendStatus fromCode(String code) {
        return Stream.of(MatchSendStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
