package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_auth_reason
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum NoAuthReason {

    _1("1", "用于非应税项目"),
    _2("2", "用于免税项目"),
    _3("3", "用户集体福利或者个人消费"),
    _4("4", "遭受非正常损失"),
    _5("5", "其他"),
    _0("0", "无");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoAuthReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoAuthReason fromCode(String code) {
        return Stream.of(NoAuthReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
