package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recog_way
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum RecogWay {

    _0("0", "--"),
    _1("1", "购方采集"),
    _2("2", "销方采集");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RecogWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecogWay fromCode(String code) {
        return Stream.of(RecogWay.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
