package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * seller_issued_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum SellerIssuedStatus {

    _1("1", "销方未开具"),
    _2("2", "销方已开具");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SellerIssuedStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerIssuedStatus fromCode(String code) {
        return Stream.of(SellerIssuedStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
