package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sign_for_status
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum SignForStatus {

    _0("0", "无"),
    _1("1", "未签收"),
    _2("2", "签收成功"),
    _3("3", "签收失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SignForStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SignForStatus fromCode(String code) {
        return Stream.of(SignForStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
