package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * transport_tool_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum TransportToolType {

    _01("01", "铁路运输"),
    _02("02", "公路运输"),
    _03("03", "水路运输"),
    _04("04", "航空运输"),
    _05("05", "管道运输"),
    _06("06", "其他运输工具"),
    _07("07", "汽运");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TransportToolType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TransportToolType fromCode(String code) {
        return Stream.of(TransportToolType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
