package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * type_of_vehicle
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum TypeOfVehicle {

    _1("1", "飞机"),
    _2("2", "火车"),
    _3("3", "长途汽车"),
    _4("4", "公共交通"),
    _5("5", "出租车"),
    _6("6", "汽车"),
    _7("7", "船舶"),
    _9("9", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TypeOfVehicle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TypeOfVehicle fromCode(String code) {
        return Stream.of(TypeOfVehicle.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
