package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * withholding_operation_type
 * </p>
 *
 * @author ultraman
 * @since 2025-09-23
 */
public enum WithholdingOperationType {

    _0("0", "撤销勾选"),
    _1("1", "勾选");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WithholdingOperationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WithholdingOperationType fromCode(String code) {
        return Stream.of(WithholdingOperationType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
