package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * back_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum BackStatus {

    _1("1", "接收成功"),
    _2("2", "接收失败"),
    _0("0", "未接收");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BackStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BackStatus fromCode(String code) {
        return Stream.of(BackStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
