package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * el_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum ElFlag {

    _0("0", "未勾选"),
    _1("1", "已勾选"),
    _4("4", "已认证"),
    _5("5", "不可勾选");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ElFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ElFlag fromCode(String code) {
        return Stream.of(ElFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
