package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext13_wilmar
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum Ext13Wilmar {

    _0("0", "未保存"),
    _1("1", "未采集影像"),
    _3("3", "已保存");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext13Wilmar(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext13Wilmar fromCode(String code) {
        return Stream.of(Ext13Wilmar.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
