package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext20_wilmar
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum Ext20Wilmar {

    _0("0", "-"),
    _1("1", "不可认证");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext20Wilmar(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext20Wilmar fromCode(String code) {
        return Stream.of(Ext20Wilmar.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
